/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.ExecutorMetrics$;
import org.apache.spark.executor.ExecutorMetricsPoller$TCMP$;
import org.apache.spark.executor.ExecutorMetricsSource;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-a!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006)\u0002!\t!V\u0003\u00055\u0002\u00011LB\u0003b\u0001\u0001[#\r\u0003\u0005j\r\tU\r\u0011\"\u0001k\u0011!YgA!E!\u0002\u0013I\u0005\u0002\u00037\u0007\u0005+\u0007I\u0011A7\t\u0011i4!\u0011#Q\u0001\n9DQ\u0001\u0016\u0004\u0005\u0002mD\u0011\"!\u0001\u0007\u0003\u0003%\t!a\u0001\t\u0013\u0005%a!%A\u0005\u0002\u0005-\u0001\"CA\u0011\rE\u0005I\u0011AA\u0012\u0011%\t9CBA\u0001\n\u0003\nI\u0003C\u0005\u00028\u0019\t\t\u0011\"\u0001\u0002:!I\u00111\b\u0004\u0002\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u00132\u0011\u0011!C!\u0003\u0017B\u0011\"!\u0017\u0007\u0003\u0003%\t!a\u0017\t\u0013\u0005\u0015d!!A\u0005B\u0005\u001d\u0004\"CA5\r\u0005\u0005I\u0011IA6\u0011%\tiGBA\u0001\n\u0003\nyg\u0002\u0006\u0002t\u0001\t\t\u0011#\u0001,\u0003k2\u0011\"\u0019\u0001\u0002\u0002#\u00051&a\u001e\t\rQCB\u0011AAC\u0011%\tI\u0007GA\u0001\n\u000b\nY\u0007C\u0005\u0002\bb\t\t\u0011\"!\u0002\n\"I\u0011q\u0012\r\u0002\u0002\u0013\u0005\u0015\u0011\u0013\u0005\u000b\u00037\u0003!\u0019!C\u0001W\u0005u\u0005\u0002CAU\u0001\u0001\u0006I!a(\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0006\u0002CAY\u0001\u0001\u0006I!a,\t\u0013\u0005M\u0006A1A\u0005\n\u0005U\u0006\u0002CA`\u0001\u0001\u0006I!a.\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"9\u00111\u001a\u0001\u0005\u0002\u0005\r\u0007bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\t)\u0010C\u0004\u0003\n\u0001!\t!a1\u0003+\u0015CXmY;u_JlU\r\u001e:jGN\u0004v\u000e\u001c7fe*\u0011A&L\u0001\tKb,7-\u001e;pe*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xmE\u0002\u0001ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e?\u001b\u0005a$BA\u001f.\u0003!Ig\u000e^3s]\u0006d\u0017BA =\u0005\u001daunZ4j]\u001e\fQ\"\\3n_JLX*\u00198bO\u0016\u00148\u0001\u0001\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b6\na!\\3n_JL\u0018BA$E\u00055iU-\\8ss6\u000bg.Y4fe\u0006y\u0001o\u001c7mS:<\u0017J\u001c;feZ\fG\u000e\u0005\u00026\u0015&\u00111J\u000e\u0002\u0005\u0019>tw-A\u000bfq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t'>,(oY3\u0011\u0007Ur\u0005+\u0003\u0002Pm\t1q\n\u001d;j_:\u0004\"!\u0015*\u000e\u0003-J!aU\u0016\u0003+\u0015CXmY;u_JlU\r\u001e:jGN\u001cv.\u001e:dK\u00061A(\u001b8jiz\"BAV,Y3B\u0011\u0011\u000b\u0001\u0005\u0006\u0001\u0012\u0001\rA\u0011\u0005\u0006\u0011\u0012\u0001\r!\u0013\u0005\u0006\u0019\u0012\u0001\r!\u0014\u0002\t'R\fw-Z&fsB!Q\u0007\u00180_\u0013\tifG\u0001\u0004UkBdWM\r\t\u0003k}K!\u0001\u0019\u001c\u0003\u0007%sGO\u0001\u0003U\u00076\u00036\u0003\u0002\u00045G\u001a\u0004\"!\u000e3\n\u0005\u00154$a\u0002)s_\u0012,8\r\u001e\t\u0003k\u001dL!\u0001\u001b\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\r|WO\u001c;\u0016\u0003%\u000baaY8v]R\u0004\u0013!\u00029fC.\u001cX#\u00018\u0011\u0005=DX\"\u00019\u000b\u0005E\u0014\u0018AB1u_6L7M\u0003\u0002ti\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002za\ny\u0011\t^8nS\u000eduN\\4BeJ\f\u00170\u0001\u0004qK\u0006\\7\u000f\t\u000b\u0004yz|\bCA?\u0007\u001b\u0005\u0001\u0001\"B5\f\u0001\u0004I\u0005\"\u00027\f\u0001\u0004q\u0017\u0001B2paf$R\u0001`A\u0003\u0003\u000fAq!\u001b\u0007\u0011\u0002\u0003\u0007\u0011\nC\u0004m\u0019A\u0005\t\u0019\u00018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0002\u0016\u0004\u0013\u0006=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ma'\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0005\u0016\u0004]\u0006=\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022Y\fA\u0001\\1oO&!\u0011QGA\u0018\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\ta,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0012Q\t\t\u0004k\u0005\u0005\u0013bAA\"m\t\u0019\u0011I\\=\t\u0011\u0005\u001d\u0013#!AA\u0002y\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA'!\u0019\ty%!\u0016\u0002@5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'2\u0014AC2pY2,7\r^5p]&!\u0011qKA)\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00131\r\t\u0004k\u0005}\u0013bAA1m\t9!i\\8mK\u0006t\u0007\"CA$'\u0005\u0005\t\u0019AA \u0003!A\u0017m\u001d5D_\u0012,G#\u00010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0002\r\u0015\fX/\u00197t)\u0011\ti&!\u001d\t\u0013\u0005\u001dc#!AA\u0002\u0005}\u0012\u0001\u0002+D\u001bB\u0003\"! \r\u0014\ta\tIH\u001a\t\b\u0003w\n\t)\u00138}\u001b\t\tiHC\u0002\u0002\u0000Y\nqA];oi&lW-\u0003\u0003\u0002\u0004\u0006u$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011QO\u0001\u0006CB\u0004H.\u001f\u000b\u0006y\u0006-\u0015Q\u0012\u0005\u0006Sn\u0001\r!\u0013\u0005\u0006Yn\u0001\rA\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019*a&\u0011\tUr\u0015Q\u0013\t\u0005kqKe\u000e\u0003\u0005\u0002\u001ar\t\t\u00111\u0001}\u0003\rAH\u0005M\u0001\ngR\fw-\u001a+D\u001bB+\"!a(\u0011\u000f\u0005\u0005\u00161UATy6\t!/C\u0002\u0002&J\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tiX!\u0001\u0006ti\u0006<W\rV\"N!\u0002\nq\u0002^1tW6+GO]5d!\u0016\f7n]\u000b\u0003\u0003_\u0003b!!)\u0002$&s\u0017\u0001\u0005;bg.lU\r\u001e:jGB+\u0017m[:!\u0003\u0019\u0001x\u000e\u001c7feV\u0011\u0011q\u0017\t\u0005k9\u000bI\f\u0005\u0003\u0002\"\u0006m\u0016bAA_e\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u000fA|G\u000e\\3sA\u0005!\u0001o\u001c7m)\t\t)\rE\u00026\u0003\u000fL1!!37\u0005\u0011)f.\u001b;\u0002\u000bM$\u0018M\u001d;\u0002\u0017=tG+Y:l'R\f'\u000f\u001e\u000b\t\u0003\u000b\f\t.!6\u0002Z\"1\u00111[\u0013A\u0002%\u000ba\u0001^1tW&#\u0007BBAlK\u0001\u0007a,A\u0004ti\u0006<W-\u00133\t\r\u0005mW\u00051\u0001_\u00039\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012\f\u0001c\u001c8UCN\\7i\\7qY\u0016$\u0018n\u001c8\u0015\u0011\u0005\u0015\u0017\u0011]Ar\u0003KDa!a5'\u0001\u0004I\u0005BBAlM\u0001\u0007a\f\u0003\u0004\u0002\\\u001a\u0002\rAX\u0001\u0013O\u0016$H+Y:l\u001b\u0016$(/[2QK\u0006\\7\u000f\u0006\u0003\u0002l\u0006E\b\u0003B\u001b\u0002n&K1!a<7\u0005\u0015\t%O]1z\u0011\u0019\t\u0019n\na\u0001\u0013\u0006\u0011r-\u001a;Fq\u0016\u001cW\u000f^8s+B$\u0017\r^3t)\t\t9\u0010\u0005\u0005\u0002z\u0006}\u0018q\u0015B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006E\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0005\u0003\tYPA\u0004ICNDW*\u00199\u0011\u0007E\u0013)!C\u0002\u0003\b-\u0012q\"\u0012=fGV$xN]'fiJL7m]\u0001\u0005gR|\u0007\u000f")
public class ExecutorMetricsPoller
implements Logging {
    private volatile ExecutorMetricsPoller$TCMP$ TCMP$module;
    private final MemoryManager memoryManager;
    private final long pollingInterval;
    private final Option<ExecutorMetricsSource> executorMetricsSource;
    private final ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP;
    private final ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks;
    private final Option<ScheduledExecutorService> poller;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public ExecutorMetricsPoller$TCMP$ TCMP() {
        if (this.TCMP$module == null) {
            this.TCMP$lzycompute$1();
        }
        return this.TCMP$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP() {
        return this.stageTCMP;
    }

    private ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks() {
        return this.taskMetricPeaks;
    }

    private Option<ScheduledExecutorService> poller() {
        return this.poller;
    }

    public void poll() {
        long[] latestMetrics = ExecutorMetrics$.MODULE$.getCurrentMetrics(this.memoryManager);
        this.executorMetricsSource.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.updateMetricsSnapshot(latestMetrics);
            return BoxedUnit.UNIT;
        });
        this.stageTCMP().forEachValue(Long.MAX_VALUE, v -> ExecutorMetricsPoller.updatePeaks$1(v.peaks(), latestMetrics));
        this.taskMetricPeaks().forEachValue(Long.MAX_VALUE, metrics -> ExecutorMetricsPoller.updatePeaks$1(metrics, latestMetrics));
    }

    public void start() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> {
            Runnable pollingTask = () -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.poll());
            return exec.scheduleAtFixedRate(pollingTask, 0L, $this.pollingInterval, TimeUnit.MILLISECONDS);
        });
    }

    public void onTaskStart(long taskId, int stageId, int stageAttemptId) {
        this.taskMetricPeaks().put(BoxesRunTime.boxToLong((long)taskId), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
        TCMP countAndPeaks = this.stageTCMP().compute((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (k, v) -> {
            if (v == null) {
                return new TCMP(this, 1L, new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
            }
            return new TCMP(this, v.count() + 1L, v.peaks());
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stageId).append(", ").append(stageAttemptId).append(") -> ").append(countAndPeaks.count()).toString());
    }

    public void onTaskCompletion(long taskId, int stageId, int stageAttemptId) {
        this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (stage, countAndPeaks) -> this.decrementCount$1((Tuple2)stage, (TCMP)countAndPeaks));
        this.taskMetricPeaks().remove(BoxesRunTime.boxToLong((long)taskId));
    }

    public long[] getTaskMetricPeaks(long taskId) {
        long[] metricPeaks;
        block0: {
            AtomicLongArray currentPeaks = this.taskMetricPeaks().get(BoxesRunTime.boxToLong((long)taskId));
            metricPeaks = new long[ExecutorMetricType$.MODULE$.numMetrics()];
            if (currentPeaks == null) break block0;
            ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorMetricsPoller.$anonfun$getTaskMetricPeaks$1(metricPeaks, currentPeaks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return metricPeaks;
    }

    public HashMap<Tuple2<Object, Object>, ExecutorMetrics> getExecutorUpdates() {
        HashMap executorUpdates = new HashMap();
        this.stageTCMP().replaceAll((k, v) -> this.getUpdateAndResetPeaks$1((Tuple2)k, (TCMP)v, executorUpdates));
        executorUpdates.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 k2 = (Tuple2)tuple2._1();
                return this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)k2, (k, v) -> this.removeIfInactive$1((Tuple2)k, (TCMP)v));
            }
            throw new MatchError((Object)tuple2);
        });
        return executorUpdates;
    }

    public void stop() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)ExecutorMetricsPoller.$anonfun$stop$1(exec)));
    }

    private final void TCMP$lzycompute$1() {
        ExecutorMetricsPoller executorMetricsPoller = this;
        synchronized (executorMetricsPoller) {
            if (this.TCMP$module == null) {
                this.TCMP$module = new ExecutorMetricsPoller$TCMP$(this);
            }
        }
    }

    private static final void updatePeaks$1(AtomicLongArray metrics, long[] latestMetrics$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), metrics.length()).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> metrics.getAndAccumulate(i, latestMetrics$1[i], (x, y) -> package$.MODULE$.max(x, y)));
    }

    private final TCMP decrementCount$1(Tuple2 stage, TCMP countAndPeaks) {
        long countValue = countAndPeaks.count() - 1L;
        Predef$.MODULE$.assert(countValue >= 0L, (Function0 & Serializable & scala.Serializable)() -> "task count shouldn't below 0");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stage._1$mcI$sp()).append(", ").append(stage._2$mcI$sp()).append(") -> ").append(countValue).toString());
        return new TCMP(this, countValue, countAndPeaks.peaks());
    }

    public static final /* synthetic */ void $anonfun$getTaskMetricPeaks$1(long[] metricPeaks$1, AtomicLongArray currentPeaks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._2$mcI$sp();
            metricPeaks$1[i] = currentPeaks$1.get(i);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final TCMP getUpdateAndResetPeaks$1(Tuple2 k, TCMP v, HashMap executorUpdates$1) {
        executorUpdates$1.put((Object)k, (Object)new ExecutorMetrics(v.peaks()));
        return new TCMP(this, v.count(), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
    }

    private final TCMP removeIfInactive$1(Tuple2 k, TCMP v) {
        if (v.count() == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("removing (").append(k._1$mcI$sp()).append(", ").append(k._2$mcI$sp()).append(") from stageTCMP").toString());
            return null;
        }
        return v;
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(ScheduledExecutorService exec) {
        exec.shutdown();
        return exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorMetricsPoller(MemoryManager memoryManager, long pollingInterval, Option<ExecutorMetricsSource> executorMetricsSource) {
        this.memoryManager = memoryManager;
        this.pollingInterval = pollingInterval;
        this.executorMetricsSource = executorMetricsSource;
        Logging.$init$((Logging)this);
        this.stageTCMP = new ConcurrentHashMap();
        this.taskMetricPeaks = new ConcurrentHashMap();
        this.poller = pollingInterval > 0L ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-metrics-poller")) : None$.MODULE$;
    }

    public class TCMP
    implements Product,
    scala.Serializable {
        private final long count;
        private final AtomicLongArray peaks;
        public final /* synthetic */ ExecutorMetricsPoller $outer;

        public long count() {
            return this.count;
        }

        public AtomicLongArray peaks() {
            return this.peaks;
        }

        public TCMP copy(long count, AtomicLongArray peaks) {
            return new TCMP(this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer(), count, peaks);
        }

        public long copy$default$1() {
            return this.count();
        }

        public AtomicLongArray copy$default$2() {
            return this.peaks();
        }

        public String productPrefix() {
            return "TCMP";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.count());
                }
                case 1: {
                    return this.peaks();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TCMP;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.count()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.peaks()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TCMP)) return false;
            if (((TCMP)object).org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() != this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TCMP tCMP = (TCMP)x$1;
            if (this.count() != tCMP.count()) return false;
            AtomicLongArray atomicLongArray = this.peaks();
            AtomicLongArray atomicLongArray2 = tCMP.peaks();
            if (atomicLongArray == null) {
                if (atomicLongArray2 != null) {
                    return false;
                }
            } else if (!atomicLongArray.equals(atomicLongArray2)) return false;
            if (!tCMP.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorMetricsPoller org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() {
            return this.$outer;
        }

        public TCMP(ExecutorMetricsPoller $outer, long count, AtomicLongArray peaks) {
            this.count = count;
            this.peaks = peaks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

