/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.orca;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Contexts;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCallHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.protobuf.ProtoUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.CallMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.InternalCallMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.InternalMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.MetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.MetricReport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9127")
public final class OrcaMetricReportingServerInterceptor
implements ServerInterceptor {
    private static final OrcaMetricReportingServerInterceptor INSTANCE = new OrcaMetricReportingServerInterceptor(null);
    @VisibleForTesting
    static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of("endpoint-load-metrics-bin", ProtoUtils.metadataMarshaller(OrcaLoadReport.getDefaultInstance()));
    @Nullable
    private final MetricRecorder metricRecorder;

    @VisibleForTesting
    OrcaMetricReportingServerInterceptor(@Nullable MetricRecorder metricRecorder) {
        this.metricRecorder = metricRecorder;
    }

    public static OrcaMetricReportingServerInterceptor getInstance() {
        return INSTANCE;
    }

    public static OrcaMetricReportingServerInterceptor create(@Nullable MetricRecorder metricRecorder) {
        return new OrcaMetricReportingServerInterceptor(metricRecorder);
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context ctx = Context.current();
        CallMetricRecorder callMetricRecorder = InternalCallMetricRecorder.CONTEXT_KEY.get(ctx);
        if (callMetricRecorder == null) {
            callMetricRecorder = InternalCallMetricRecorder.newCallMetricRecorder();
            ctx = ctx.withValue(InternalCallMetricRecorder.CONTEXT_KEY, callMetricRecorder);
        }
        final CallMetricRecorder finalCallMetricRecorder = callMetricRecorder;
        ForwardingServerCall.SimpleForwardingServerCall trailerAttachingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            @Override
            public void close(Status status, Metadata trailers) {
                OrcaLoadReport.Builder reportBuilder = OrcaMetricReportingServerInterceptor.this.metricRecorder != null ? OrcaMetricReportingServerInterceptor.fromInternalReport(InternalMetricRecorder.getMetricReport(OrcaMetricReportingServerInterceptor.this.metricRecorder)) : OrcaLoadReport.newBuilder();
                OrcaMetricReportingServerInterceptor.mergeMetrics(reportBuilder, InternalCallMetricRecorder.finalizeAndDump2(finalCallMetricRecorder));
                OrcaLoadReport report = reportBuilder.build();
                if (!report.equals(OrcaLoadReport.getDefaultInstance())) {
                    trailers.put(ORCA_ENDPOINT_LOAD_METRICS_KEY, report);
                }
                super.close(status, trailers);
            }
        };
        return Contexts.interceptCall(ctx, trailerAttachingCall, headers, next);
    }

    private static OrcaLoadReport.Builder fromInternalReport(MetricReport internalReport) {
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setApplicationUtilization(internalReport.getApplicationUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).setRpsFractional(internalReport.getQps()).setEps(internalReport.getEps()).putAllUtilization(internalReport.getUtilizationMetrics()).putAllRequestCost(internalReport.getRequestCostMetrics()).putAllNamedMetrics(internalReport.getNamedMetrics());
    }

    private static void mergeMetrics(OrcaLoadReport.Builder metricRecorderReportBuilder, MetricReport callMetricRecorderReport) {
        double eps;
        double rps;
        double mem;
        double applicationUtilization;
        metricRecorderReportBuilder.putAllUtilization(callMetricRecorderReport.getUtilizationMetrics()).putAllRequestCost(callMetricRecorderReport.getRequestCostMetrics()).putAllNamedMetrics(callMetricRecorderReport.getNamedMetrics());
        double cpu = callMetricRecorderReport.getCpuUtilization();
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(cpu)) {
            metricRecorderReportBuilder.setCpuUtilization(cpu);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(applicationUtilization = callMetricRecorderReport.getApplicationUtilization())) {
            metricRecorderReportBuilder.setApplicationUtilization(applicationUtilization);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(mem = callMetricRecorderReport.getMemoryUtilization())) {
            metricRecorderReportBuilder.setMemUtilization(mem);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(rps = callMetricRecorderReport.getQps())) {
            metricRecorderReportBuilder.setRpsFractional(rps);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(eps = callMetricRecorderReport.getEps())) {
            metricRecorderReportBuilder.setEps(eps);
        }
    }

    private static boolean isReportValueSet(double value) {
        return value != 0.0;
    }
}

