/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToNumber$;
import org.apache.spark.sql.catalyst.expressions.ToNumberBase;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format 'fmt'.\n       Throws an exception if the conversion fails. The format can consist of the following\n       characters, case insensitive:\n         '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n           string matches a sequence of digits in the input string. If the 0/9 sequence starts with\n           0 and is before the decimal point, it can only match a digit sequence of the same size.\n           Otherwise, if the sequence starts with 9 or is after the decimal point, it can match a\n           digit sequence that has the same or smaller size.\n         '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n         ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n           a 0 or 9 to the left and right of each grouping separator. 'expr' must match the\n           grouping separator relevant for the size of the number.\n         '$': Specifies the location of the $ currency sign. This character may only be specified\n           once.\n         'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n           the beginning or end of the format string). Note that 'S' allows '-' but 'MI' does not.\n         'PR': Only allowed at the end of the format string; specifies that 'expr' indicates a\n           negative number with wrapping angled brackets.\n           ('<1>').\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\r\u001a\u0001\u001aB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0012)A\u0005m!A!\b\u0001BK\u0002\u0013\u0005Q\u0007\u0003\u0005<\u0001\tE\t\u0015!\u00037\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\t\u0005\u0001\"\u0011C\u0011\u0015q\u0005\u0001\"\u0015P\u0011\u001d!\u0006!!A\u0005\u0002UCq\u0001\u0017\u0001\u0012\u0002\u0013\u0005\u0011\fC\u0004e\u0001E\u0005I\u0011A-\t\u000f\u0015\u0004\u0011\u0011!C!M\"9a\u000eAA\u0001\n\u0003y\u0007bB:\u0001\u0003\u0003%\t\u0001\u001e\u0005\bu\u0002\t\t\u0011\"\u0011|\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u0012\u0001\t\t\u0011\"\u0011\u0002\u0014\u001dI\u0011qG\r\u0002\u0002#\u0005\u0011\u0011\b\u0004\t1e\t\t\u0011#\u0001\u0002<!1AH\u0005C\u0001\u0003\u0013B\u0011\"a\u0013\u0013\u0003\u0003%)%!\u0014\t\u0013\u0005=##!A\u0005\u0002\u0006E\u0003\"CA,%\u0005\u0005I\u0011QA-\u0011%\tYGEA\u0001\n\u0013\tiG\u0001\u0005U_:+XNY3s\u0015\tQ2$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011\u0003\u0002\u0001(WE\u0002\"\u0001K\u0015\u000e\u0003eI!AK\r\u0003\u0019Q{g*^7cKJ\u0014\u0015m]3\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\u000fA\u0013x\u000eZ;diB\u0011AFM\u0005\u0003g5\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\ta\u0007\u0005\u0002)o%\u0011\u0001(\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004}}\u0002\u0005C\u0001\u0015\u0001\u0011\u0015!T\u00011\u00017\u0011\u0015QT\u00011\u00017\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u0007B\u0011Ai\u0013\b\u0003\u000b&\u0003\"AR\u0017\u000e\u0003\u001dS!\u0001S\u0013\u0002\rq\u0012xn\u001c;?\u0013\tQU&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u0013aa\u0015;sS:<'B\u0001&.\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002?!JCQ!U\u0004A\u0002Y\nqA\\3x\u0019\u00164G\u000fC\u0003T\u000f\u0001\u0007a'\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007y2v\u000bC\u00045\u0011A\u0005\t\u0019\u0001\u001c\t\u000fiB\u0001\u0013!a\u0001m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001.+\u0005YZ6&\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!C;oG\",7m[3e\u0015\t\tW&\u0001\u0006b]:|G/\u0019;j_:L!a\u00190\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011a\u0017M\\4\u000b\u00031\fAA[1wC&\u0011A*[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002aB\u0011A&]\u0005\u0003e6\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"!\u001e=\u0011\u000512\u0018BA<.\u0005\r\te.\u001f\u0005\bs6\t\t\u00111\u0001q\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tA\u0010\u0005\u0003~\u0003\u0003)X\"\u0001@\u000b\u0005}l\u0013AC2pY2,7\r^5p]&\u0019\u00111\u0001@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\ty\u0001E\u0002-\u0003\u0017I1!!\u0004.\u0005\u001d\u0011un\u001c7fC:Dq!_\b\u0002\u0002\u0003\u0007Q/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0013\t)\u0002C\u0004z!\u0005\u0005\t\u0019A;)'\u0001\tI\"a\b\u0002\"\u0005\u0015\u0012qEA\u0016\u0003[\t\t$a\r\u0011\u0007!\nY\"C\u0002\u0002\u001ee\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002$\u0005YYO\u0003\u0011!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u00043\u000f\u001e:j]\u001e\u0004s%\u001a=qe\u001e\u0002Co\u001c\u0011bA9,XNY3sA\t\f7/\u001a3!_:\u0004C\u000f[3!gR\u0014\u0018N\\4!M>\u0014X.\u0019;!O\u0019lGo\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!)\"\u0014xn^:!C:\u0004S\r_2faRLwN\u001c\u0011jM\u0002\"\b.\u001a\u0011d_:4XM]:j_:\u0004c-Y5mg:\u0002C\u000b[3!M>\u0014X.\u0019;!G\u0006t\u0007eY8og&\u001cH\u000fI8gAQDW\r\t4pY2|w/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!A\rD\u0017M]1di\u0016\u00148\u000f\f\u0011dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wKjR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u00141O\u0001z'\u000fI\u0014:Oi\u00023\u000b]3dS\u001aLWm\u001d\u0011b]\u0002*\u0007\u0010]3di\u0016$\u0007\u0005Z5hSR\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u0011b]\u0012\u0004\u0013H\f\u0011BAM,\u0017/^3oG\u0016\u0004sN\u001a\u00111A=\u0014\b%\u000f\u0011j]\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000f\u001e:j]\u001e\u0004S.\u0019;dQ\u0016\u001c\b%\u0019\u0011tKF,XM\\2fA=4\u0007\u0005Z5hSR\u001c\b%\u001b8!i\",\u0007%\u001b8qkR\u00043\u000f\u001e:j]\u001et\u0003%\u00134!i\",\u0007\u0005M\u0018:AM,\u0017/^3oG\u0016\u00043\u000f^1siN\u0004s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!C:$\u0007%[:!E\u00164wN]3!i\",\u0007\u0005Z3dS6\fG\u000e\t9pS:$H\u0006I5uA\r\fg\u000eI8oYf\u0004S.\u0019;dQ\u0002\n\u0007\u0005Z5hSR\u00043/Z9vK:\u001cW\rI8gAQDW\rI:b[\u0016\u00043/\u001b>f])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Pi\",'o^5tK2\u0002\u0013N\u001a\u0011uQ\u0016\u00043/Z9vK:\u001cW\rI:uCJ$8\u000fI<ji\"\u0004\u0013\bI8sA%\u001c\b%\u00194uKJ\u0004C\u000f[3!I\u0016\u001c\u0017.\\1mAA|\u0017N\u001c;-A%$\beY1oA5\fGo\u00195!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eS\u001eLG\u000fI:fcV,gnY3!i\"\fG\u000f\t5bg\u0002\"\b.\u001a\u0011tC6,\u0007e\u001c:!g6\fG\u000e\\3sAML'0\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001:cf\n\u0011pe\u0002:Ci\n\u001e!'B,7-\u001b4jKN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002zg\r\t;iK\u0002\"WmY5nC2\u0004\u0003o\\5oi\u0002Bs\u000e\u001d;j_:\fG\u000e\f\u0011p]2L\b%\u00197m_^,G\rI8oG\u0016LcF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!O1:\u0003e\u001c:!O\u001d;#\bI*qK\u000eLg-[3tAQDW\r\t9pg&$\u0018n\u001c8!_\u001a\u0004C\u000f[3!OJ|W\u000f]5oO\u0002BC\u000f[8vg\u0006tGm]\u0015!g\u0016\u0004\u0018M]1u_J\u0004\u0003\u0006L\u0015/AQCWM]3![V\u001cH\u000f\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1!a\u0001z'\u000fI\u001d!i>\u0004C\u000f[3!Y\u00164G\u000fI1oI\u0002\u0012\u0018n\u001a5uA=4\u0007%Z1dQ\u0002:'o\\;qS:<\u0007e]3qCJ\fGo\u001c:/A\u001d*\u0007\u0010\u001d:(A5,8\u000f\u001e\u0011nCR\u001c\u0007\u000e\t;iK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011he>,\b/\u001b8hAM,\u0007/\u0019:bi>\u0014\bE]3mKZ\fg\u000e\u001e\u0011g_J\u0004C\u000f[3!g&TX\rI8gAQDW\r\t8v[\n,'O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u001d\"sE\u000f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011m_\u000e\fG/[8oA=4\u0007\u0005\u001e5fA\u0011\u00023-\u001e:sK:\u001c\u0017\u0010I:jO:t\u0003\u0005\u00165jg\u0002\u001a\u0007.\u0019:bGR,'\u000fI7bs\u0002zg\u000e\\=!E\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002sN\\2f])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003eJ*(A=\u0014\beJ'JOi\u00023\u000b]3dS\u001aLWm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI8gA\u0005\u0004s%L\u0014!_J\u0004seK\u0014!g&<g\u000e\t\u0015paRLwN\\1mY\u0001zg\u000e\\=!C2dwn^3eA=t7-\u001a\u0011bi*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004#-Z4j]:Lgn\u001a\u0011pe\u0002*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011tiJLgnZ\u0015/A9{G/\u001a\u0011uQ\u0006$\beJ*(A\u0005dGn\\<tA\u001djs\u0005\t2vi\u0002:S*S\u0014!I>,7\u000f\t8pi:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0014Q%\u001eR\u0004e\u00148ms\u0002\nG\u000e\\8xK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!M>\u0014X.\u0019;!gR\u0014\u0018N\\4<AM\u0004XmY5gS\u0016\u001c\b\u0005\u001e5bi\u0002:S\r\u001f9sO\u0001Jg\u000eZ5dCR,7\u000fI1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\\3hCRLg/\u001a\u0011ok6\u0014WM\u001d\u0011xSRD\u0007e\u001e:baBLgn\u001a\u0011b]\u001edW\r\u001a\u0011ce\u0006\u001c7.\u001a;t])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011)Oq\ndhJ\u0015/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005%\u0012Aa\u0016\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007N\u0014-A\u001dJ\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"T\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OQ*DG\f\u00191O1\u0002s\u0005\r\u00191]A\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iU\"d\u0006\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i\u001db\u0003eJ\u001d:YeJ\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012D'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"s\u0007\u000f\u00182e\u001db\u0003e\n\u0013:s9J\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]Bd&\r\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i9BTf\n\u0017!OeJD&O\u001d:]e\u001av%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![E\u0012D'\u000e\u001b/q)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00020\u0005)1GL\u001a/a\u0005)qM]8va\u0006\u0012\u0011QG\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\t)>tU/\u001c2feB\u0011\u0001FE\n\u0005%\u0005u\u0012\u0007E\u0004\u0002@\u0005\u0015cG\u000e \u000e\u0005\u0005\u0005#bAA\"[\u00059!/\u001e8uS6,\u0017\u0002BA$\u0003\u0003\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tI$\u0001\u0005u_N#(/\u001b8h)\u00059\u0017!B1qa2LH#\u0002 \u0002T\u0005U\u0003\"\u0002\u001b\u0016\u0001\u00041\u0004\"\u0002\u001e\u0016\u0001\u00041\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00037\n9\u0007E\u0003-\u0003;\n\t'C\u0002\u0002`5\u0012aa\u00149uS>t\u0007#\u0002\u0017\u0002dY2\u0014bAA3[\t1A+\u001e9mKJB\u0001\"!\u001b\u0017\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001c\u0011\u0007!\f\t(C\u0002\u0002t%\u0014aa\u00142kK\u000e$\b")
public class ToNumber
extends ToNumberBase {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToNumber toNumber) {
        return ToNumber$.MODULE$.unapply(toNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, ToNumber> tupled() {
        return ToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToNumber>> curried() {
        return ToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String prettyName() {
        return "to_number";
    }

    @Override
    public ToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ToNumber copy(Expression left, Expression right) {
        return new ToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToNumber toNumber = (ToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = toNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toNumber.canEqual(this)) return false;
        return true;
    }

    public ToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super(left, right, true);
    }
}

